<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductReview extends Model 
{

    protected $table = 'product_reviews';
    public $timestamps = true;
    protected $fillable = array('comment', 'rating', 'client_id', 'product_id');

    public function clients()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function product()
    {
        return $this->belongsTo('App\Models\Product');
    }

}